-- file not used: not localized
-- PhysX GUI for cloth

rollout px_cloth_attachment "Cloth Attachment"
(
	checkbox  flag_attach_tearing "Tearable"            align:#left  width:90        -- NX_CLOTH_ATTACHMENT_TEARABLE
	spinner   attachtearingFactor "Tearing Factor"      align:#right width:90 range:[1.01, PxMaxValue, 1.5] scale:0.01
	checkbox  flag_attach_twoway  "Two-way interaction" align:#left                  -- NX_CLOTH_ATTACHMENT_TWOWAY 
	spinner   attachtwowayresp    "Two-way Resp."       align:#right width:90 range:[0, 1, 0.2] scale:0.01
	checkbox  flag_adhere         "Adhere to RB"        align:#left                  -- NX_CLF_ADHERE 
	spinner   adherevelocity      "Min Adhere Velocity" align:#right width:90 range:[0, PxMaxValue, 1] scale:0.01

	label		  attachlbl		  "Attach Method"       align:#left across:2
	dropdownlist  attachMethod    ""                    align:#right items:#("not attach", "Automated", "User Define")
	listbox   attachments         caption:"List of Attachments"  height:5   items:#()
	button    add                 "Add"                align:#right across:2 tooltip:"Add tearing surface which cuts the cloth"
	button    remove              "Remove"             align:#right 

	on add pressed do ()
	on remove pressed do ()
	
	fn loadValues =
	(
		flag_attach_tearing.checked = PxGetNodeUserProp pxCurrentNode "px_clf_attachment_tearable" false
		attachtearingFactor.value = PxGetNodeUserProp pxCurrentNode "px_clp_attachTearFactor" 1.5
		flag_attach_twoway.checked = PxGetNodeUserProp pxCurrentNode "px_clf_attachment_twoway" false
		attachtwowayresp.value = PxGetNodeUserProp pxCurrentNode "px_clp_attachResponseCoef" 0.2
		flag_adhere.checked = PxGetNodeUserProp pxCurrentNode "px_clf_attachAdhere" false
		adherevelocity.value = PxGetNodeUserProp pxCurrentNode "px_clp_attachAdhereVel" 1.0
		attachMethod.selection = PxGetNodeUserProp pxCurrentNode "px_clp_attachmode" 1
	)
	
	on px_cloth_attachment open do 
	(
		loadValues()
	)
)

fn editClothAttachment =
(
	if px_cloth_attachment != undefined then DestroyDialog px_cloth_attachment
	--format "px_cloth_attachment = %\n" px_cloth_attachment
	createDialog px_cloth_attachment width:220
)

rollout px_cloth_flags "Cloth Flags"
(
	checkbox  flag_static        "Static"             align:#left width:90 across:2       -- NX_CLF_STATIC
	checkbox  flag_gravity       "Gravity"            align:#left width:90 checked:true   -- NX_CLF_GRAVITY
	checkbox  flag_disableCCD    "Disable CCD"        align:#left width:90 across:2       -- NX_CLF_DISABLE_DYNAMIC_CCD
	checkbox  flag_hardware      "Hardware"           align:#left width:90                -- NX_CLF_HARDWARE
	checkbox  flag_damping       "Damping"            align:#left width:90 across:2       -- NX_CLF_DAMPING
	checkbox  flag_comdamping    "Comdamping"         align:#left width:90                -- NX_CLF_COMDAMPING
	checkbox  flag_bending       "Bending"            align:#left width:90 across:2       -- NX_CLF_BENDING
	checkbox  flag_bendingOtho   "Bending Otho."      align:#left width:90                -- NX_CLF_BENDING_ORTHO
	checkbox  flag_pressure      "Pressure"           align:#left width:90                -- NX_CLF_PRESSURE 
	
	fn loadValues =
	(
		flag_static.checked = PxGetNodeUserProp pxCurrentNode "px_clf_static" false
		flag_gravity.checked = PxGetNodeUserProp pxCurrentNode "px_clf_gravity" true
		flag_disableCCD.checked = PxGetNodeUserProp pxCurrentNode "px_clf_disable_dynamic_ccd" false
		flag_hardware.checked = PxGetNodeUserProp pxCurrentNode "px_clf_hardware" false
		flag_damping.checked = PxGetNodeUserProp pxCurrentNode "px_clf_damping" false
		flag_comdamping.checked = PxGetNodeUserProp pxCurrentNode "px_clf_comdamping" false
		flag_bending.checked = PxGetNodeUserProp pxCurrentNode "px_clf_bending" false
		flag_bendingOtho.checked = PxGetNodeUserProp pxCurrentNode "px_clf_bending_ortho" false
		flag_pressure.checked = PxGetNodeUserProp pxCurrentNode "px_clf_pressure" false
	)
	
	on px_cloth_flags open do
	(
		loadValues()
	)
)

fn editClothFlags =
(
	if px_cloth_flags != undefined then DestroyDialog px_cloth_flags
	--format "px_cloth_flags = %\n" px_cloth_flags
	createDialog px_cloth_flags width:220
)

rollout px_cloth_tearing "Cloth Tearing"
(
	checkbox  flag_tearing       "Tearable"           align:#left  width:90       -- NX_CLF_TEARABLE
	spinner   tearingFactor      "Tearing Factor"     align:#right width:90 range:[1.01, PxMaxValue, 1.5] scale:0.01
	label		  tearinglbl	 "Tearing Method"     align:#left across:2
	dropdownlist  tearingMethod  ""                   align:#right items:#("Automated", "User Define")
	listbox   tearingSurfaces    caption:"List of Tearing Surfaces"  height:5       items:#()
	button    add                "Add"                align:#right across:2 tooltip:"Add tearing surface which cuts the cloth"
	button    remove             "Remove"             align:#right 
	
	on add pressed do ()
	on remove pressed do ()

	fn loadValues =
	(
		flag_tearing.checked = PxGetNodeUserProp pxCurrentNode "px_clf_tearable" false
		tearingFactor.value = PxGetNodeUserProp pxCurrentNode "px_clp_tearFactor" 1.5
		autoMode = PxGetNodeUserProp pxCurrentNode "px_cll_autotearing" true
		if autoMode then tearingMethod.selection = 1 else tearingMethod.selection = 2
	)

	on px_cloth_tearing open do
	(
		loadValues()
	)	
)

fn editClothTearing =
(
	if px_cloth_tearing != undefined then DestroyDialog px_cloth_tearing
	--format "px_cloth_tearing = %\n" px_cloth_tearing
	createDialog px_cloth_tearing width:220
)

rollout px_cloth_collisions "Cloth Collisions"
(
	checkbox  flag_selfcollision    "Enable Self Collision"              align:#left
	group "Collision with Rigidbody"
	(
		checkbox  flag_disablecollision  "Disable RB Collision"         align:#left width:90
		spinner   rbCollisionResp        "Resp. to RB"                  align:#right width:90 range:[0.01, PxMaxValue, 1.0] scale:0.01
		checkbox  flag_collisiontwoway   "Enable 2-way Collision"   align:#left
	)
	group "Collision with Fluid"
	(
		checkbox  flag_fluidcollision    "Enable Fluid Collision"       align:#left
		spinner   from_fluid_resp        "From Fluid Resp."             align:#right width:90 range:[0, PxMaxValue, 1.0] scale:0.01
		spinner   to_fluid_resp          "To Fluid Resp."               align:#right width:90 range:[0, PxMaxValue, 1.0] scale:0.01
	)
	group "Valid Bounds"
	(
		checkbox  flag_validbounds      "Enable Valid Bounds"       align:#left
		label     lbl_1                 "Min Value"                 align:#left across:4
		spinner   bounds_min_x          "x"                         range:[-PxMaxValue,PxMaxValue,0] scale:0.01 align:#right width: 50  
		spinner   bounds_min_y          "y"                         range:[-PxMaxValue,PxMaxValue,0] scale:0.01 align:#right width: 50
		spinner   bounds_min_z          "z"                         range:[-PxMaxValue,PxMaxValue,0] scale:0.01 align:#right width: 50
		label     lbl_2                 "Max Value"                 align:#left across:4
		spinner   bounds_max_x          "x"                         range:[-PxMaxValue,PxMaxValue,0] scale:0.01 align:#right width: 50  
		spinner   bounds_max_y          "y"                         range:[-PxMaxValue,PxMaxValue,0] scale:0.01 align:#right width: 50
		spinner   bounds_max_z          "z"                         range:[-PxMaxValue,PxMaxValue,0] scale:0.01 align:#right width: 50
	)
	
	fn loadValues =
	(
		flag_selfcollision.checked = PxGetNodeUserProp pxCurrentNode "px_clf_selfcollision" false
		flag_disablecollision.checked = PxGetNodeUserProp pxCurrentNode "px_clf_disable_collision" false
		rbCollisionResp.value = PxGetNodeUserProp pxCurrentNode "px_clp_collisionResponseCoef" 1.0
		flag_collisiontwoway.checked = PxGetNodeUserProp pxCurrentNode "px_clf_collision_twoway" false
		flag_fluidcollision.checked = PxGetNodeUserProp pxCurrentNode "px_clf_fluid_collision" false
		from_fluid_resp.value = PxGetNodeUserProp pxCurrentNode "px_clp_from_fluid_resp" 1.0
		to_fluid_resp.value = PxGetNodeUserProp pxCurrentNode "px_clp_to_fluid_resp" 1.0
		flag_validbounds.checked = PxGetNodeUserProp pxCurrentNode "px_clf_validbounds" false
		bounds_min_x.value = PxGetNodeUserProp pxCurrentNode "px_clp_validbounds_minx" 0
		bounds_min_y.value = PxGetNodeUserProp pxCurrentNode "px_clp_validbounds_miny" 0
		bounds_min_z.value = PxGetNodeUserProp pxCurrentNode "px_clp_validbounds_minz" 0
		bounds_max_x.value = PxGetNodeUserProp pxCurrentNode "px_clp_validbounds_maxx" 0
		bounds_max_y.value = PxGetNodeUserProp pxCurrentNode "px_clp_validbounds_maxy" 0
		bounds_max_z.value = PxGetNodeUserProp pxCurrentNode "px_clp_validbounds_maxz" 0
	)
	
	on px_cloth_collisions open do 
	(
		loadValues()
	)
)

fn editClothCollisions =
(
	if px_cloth_collisions != undefined then DestroyDialog px_cloth_collisions
	--format "px_cloth_collisions = %\n" px_cloth_collisions
	createDialog px_cloth_collisions width:220
)

rollout px_panel_cloth "PhysX Cloth" rolledUp:false
(
	label     lbl_m1      "Density"            align:#left width:120 across:2
	spinner   density ""                        align:#right width:60 range:[0.01, PxMaxValue, 1.0] scale:0.01
	label     lbl_m2      "Thickness"            align:#left width:120 across:2
	spinner   thickness ""                        align:#right width:60 range:[0, PxMaxValue, 0.01] scale:0.01
	label     lbl_m3      "Friction"            align:#left width:120 across:2
	spinner   friction ""                        align:#right width:60 range:[0, 1, 0.5] scale:0.01
	label     lbl_m7      "Bending"            align:#left width:120 across:2
	spinner   bending ""                        align:#right width:60 range:[0, 1, 0] scale:0.01
	label     lbl_m8      "Stretching"            align:#left width:120 across:2
	spinner   stretching ""                        align:#right width:60 range:[0.01, 1, 1.0] scale:0.01
	label     lbl_m9      "Damping"            align:#left width:120 across:2
	spinner   damping ""                        align:#right width:60 range:[0, 1, 0.5] scale:0.01
	label     lbl_m10      "Pressure"            align:#left width:120 across:2
	spinner   pressure ""                        align:#right width:60 range:[0, PxMaxValue, 1] scale:0.01
	label     lbl_m4      "Solver Iter."            align:#left width:120 across:2
	spinner   solverIter ""                        align:#right width:60 range:[1, PxMaxValue, 5] type:#integer
	label     lbl_m5      "Sleep Velocity"            align:#left width:120 across:2
	spinner   sleepVelocity ""                        align:#right width:60 range:[-1, PxMaxValue, -1] scale:0.01
	label     lbl_m6      "Wakeup Counter"            align:#left width:120 across:2
	spinner   wakeupCounter ""                        align:#right width:60 range:[0, PxMaxValue, 0.4] scale:0.01
		
	label         lbl_1        "Wind Acc."         align:#left
	spinner       wind_acc_x        "x"                         range:[-PxMaxValue,PxMaxValue,0] scale:0.01 align:#right width: 50  across:3
	spinner       wind_acc_y        "y"                         range:[-PxMaxValue,PxMaxValue,0] scale:0.01 align:#right width: 50
	spinner       wind_acc_z        "z"                         range:[-PxMaxValue,PxMaxValue,0] scale:0.01 align:#right width: 50
	label         lbl_2        "External Acc"         align:#left
	spinner       external_acc_x        "x"                         range:[-PxMaxValue,PxMaxValue,0] scale:0.01 align:#right width: 50  across:3
	spinner       external_acc_y        "y"                         range:[-PxMaxValue,PxMaxValue,0] scale:0.01 align:#right width: 50
	spinner       external_acc_z        "z"                         range:[-PxMaxValue,PxMaxValue,0] scale:0.01 align:#right width: 50

	group "Flags"	
	(
		checkbox  flag_static        "Static"             align:#left width:90 across:2       -- NX_CLF_STATIC
		checkbox  flag_gravity       "Gravity"            align:#left width:90 checked:true   -- NX_CLF_GRAVITY
		checkbox  flag_disableCCD    "Disable CCD"        align:#left width:90 across:2       -- NX_CLF_DISABLE_DYNAMIC_CCD
		checkbox  flag_hardware      "Hardware"           align:#left width:90                -- NX_CLF_HARDWARE
		checkbox  flag_damping       "Damping"            align:#left width:90 across:2       -- NX_CLF_DAMPING
		checkbox  flag_comdamping    "Comdamping"         align:#left width:90                -- NX_CLF_COMDAMPING
		checkbox  flag_bending       "Bending"            align:#left width:90 across:2       -- NX_CLF_BENDING
		checkbox  flag_bendingOtho   "Bending Otho."      align:#left width:90                -- NX_CLF_BENDING_ORTHO
		checkbox  flag_pressure      "Pressure"           align:#left width:90                -- NX_CLF_PRESSURE 
	)
		
	button collision   "Collisions"   align:#left  width:90 across:2
	button attachment  "Attachments"  align:#right width:90 
	--button flags       "Flags"        align:#left  width:90 across:2
	button tearing     "Tearing"      align:#right width:90
	
	on flags pressed do ( editClothFlags() )
	on attachment pressed do ( editClothAttachment() )
	on collision pressed do ( editClothCollisions() )
	on tearing pressed do ( editClothTearing() )
	
	fn loadValues =
	(
		flag_static.checked = PxGetNodeUserProp pxCurrentNode "px_clf_static" false
		flag_gravity.checked = PxGetNodeUserProp pxCurrentNode "px_clf_gravity" true
		flag_disableCCD.checked = PxGetNodeUserProp pxCurrentNode "px_clf_disable_dynamic_ccd" false
		flag_hardware.checked = PxGetNodeUserProp pxCurrentNode "px_clf_hardware" false
		flag_damping.checked = PxGetNodeUserProp pxCurrentNode "px_clf_damping" false
		flag_comdamping.checked = PxGetNodeUserProp pxCurrentNode "px_clf_comdamping" false
		flag_bending.checked = PxGetNodeUserProp pxCurrentNode "px_clf_bending" false
		flag_bendingOtho.checked = PxGetNodeUserProp pxCurrentNode "px_clf_bending_ortho" false
		flag_pressure.checked = PxGetNodeUserProp pxCurrentNode "px_clf_pressure" false
		
		wind_acc_x.value = PxGetNodeUserProp pxCurrentNode "px_clp_wind_acc_x" 0
		wind_acc_y.value = PxGetNodeUserProp pxCurrentNode "px_clp_wind_acc_y" 0
		wind_acc_z.value = PxGetNodeUserProp pxCurrentNode "px_clp_wind_acc_z" 0
		external_acc_x.value = PxGetNodeUserProp pxCurrentNode "px_clp_external_acc_x" 0
		external_acc_y.value = PxGetNodeUserProp pxCurrentNode "px_clp_external_acc_y" 0
		external_acc_z.value = PxGetNodeUserProp pxCurrentNode "px_clp_external_acc_z" 0

		density.value = PxGetNodeUserProp pxCurrentNode "px_clp_density" 1.0
		thickness.value = PxGetNodeUserProp pxCurrentNode "px_clp_thickness" 0.01
		friction.value = PxGetNodeUserProp pxCurrentNode "px_clp_friction" 0.5
		bending.value = PxGetNodeUserProp pxCurrentNode "px_clp_bendingStiffness" 0
		stretching.value = PxGetNodeUserProp pxCurrentNode "px_clp_stretchingStiffness" 1.0
		damping.value = PxGetNodeUserProp pxCurrentNode "px_clp_dampingCoefficient" 0.5
		pressure.value = PxGetNodeUserProp pxCurrentNode "px_clp_pressure" 1.0
		solverIter.value = PxGetNodeUserProp pxCurrentNode "px_clp_solverIterations" 5
		sleepVelocity.value = PxGetNodeUserProp pxCurrentNode "px_clp_sleepvel" -1.0
		wakeupCounter.value = PxGetNodeUserProp pxCurrentNode "px_clp_wakeupcounter" 0.4
	)
	
	on px_panel_cloth open do
	(
		loadValues()
	)
)


-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQA+1yEzTX5mL/R/SjE7yvzZ5GKG2KL08VJI
-- e2exwKzWuWn77bpI9BejAH4SIuB8XeZQD4KjV6mZQR1UNFyhUUnCS0DOjLgZcGNq
-- 6T4/0WIYWedlNhIhCnpZTe5jK0Rfgm3RItK9FQOgyEhoOLkU8vJ2fQdMQOQ2Brv0
-- wUOEjNmOuyLW05EU4htM23FxasLhIHTN3WhGIJqA9OooS8iJ9kJFMdYWUfTX6hsJ
-- xGOiwF6ejK/uCZr72T1VkKPSHWlRU9zc3L1bqaih4HC/01GN262Gtl0hKWTytCgM
-- gRe/jOCMHSp3S/h+57WqvkcIfjh1eEfU8MkIZfwdhJ/HfnTn3piH
-- -----END-SIGNATURE-----